import pandas as pd  
import pickle 
from decision_company import read_csv_file, extract_unique_values, convert_np_to_list, fetch_column
  
# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")   

target_customer_segments = convert_np_to_list(extract_unique_values(fetch_column(target_customers, 'cluster')))  

print("target_customer_segments:\n", target_customer_segments)    
pickle.dump(target_customer_segments,open("./ref_result/target_customer_segments.pkl","wb"))